/* - IRRawDataListener -
 * Display raw data after a raw data event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.IRPhidget;
import com.phidgets.event.RawDataEvent;
import com.phidgets.event.RawDataListener;

import javax.swing.JFrame;
import javax.swing.JTextArea;

public class IRRawDataListener implements RawDataListener {

    private JFrame appFrame;
    private JTextArea rawDataArea;
    private static int rowDataCol;

    public IRRawDataListener(JFrame appFrame, JTextArea rawDataArea) {

        this.appFrame = appFrame;
        this.rawDataArea = rawDataArea;
        rowDataCol = 0;
    }


    public void rawData(RawDataEvent rde) {
         int i = 0;
         for(i=0; i<rde.getData().length; i++){
            if(rde.getData()[i] == IRPhidget.RAWDATA_LONGSPACE){
                rawDataArea.append("\n\nLONG\n");
                rowDataCol = -1;
            }
            else if( rde.getData()[i] > 100000){
                rawDataArea.append("\n\n" + rde.getData()[i] + ", " + "\n");
                rowDataCol = -1;
            }
            else{
                rawDataArea.append(rde.getData()[i] + ", ");
                rawDataArea.setCaretPosition(rawDataArea.getDocument().getLength());
            }

            rowDataCol++;
            if(rowDataCol >= 10){
                rawDataArea.append("\n");
                rowDataCol = 0;
            }

            rawDataArea.setCaretPosition(rawDataArea.getDocument().getLength());
        }

    }
}
